/**
* \file: am_api_dispatcher.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AM_API_DISPATCHER_H
#define AM_API_DISPATCHER_H

#include <sys/epoll.h>

#include "automounter_types.h"
#include "automounter_api.h"
#include "ipc/message_buffer.h"

typedef void (*event_handler_t)(uint32_t event_mask);

error_code_t am_api_dispatcher_init(void);

void am_api_dispatcher_deinit(void);

void am_api_dispatcher_signal_establish_connection_success(void);

void am_api_dispatcher_signal_establish_connection_failure(void);

void am_api_dispatcher_signal_connection_lost(void);

int am_api_dispatcher_get_pollfd(void);

void am_api_dispatcher_dispatch_event(void);

error_code_t am_api_dispatcher_register_event_fd(int fd, event_handler_t handler, uint32_t event_mask);

error_code_t am_api_dispatcher_change_eventfd_eventmask(int fd, event_handler_t handler, uint32_t event_mask);

void am_api_dispatcher_deregister_event_fd(int fd);

void am_api_dispatcher_on_message_received(message_buffer_t *recvr_buffer);


#endif
